/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import model.Ant;
import model.MapPoint;

public class MapPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private final Color COLOR_BORDER = new Color(156, 93, 82);
    private final Color COLOR_FOOD = new Color(42, 194, 12);
    private final Color COLOR_HIVE = new Color(88, 88, 88);
    private final Color COLOR_ANTS = Color.black;
    private final Color COLOR_ANTS_RETURNER = Color.green;
    private final Color COLOR_ANTS_RETURNER2 = Color.black;
    private final Color COLOR_ANTS_FOLLOWER = Color.blue;
    private final Color COLOR_EMPTY = Color.white;
    public static final int BRUSH_LIKE_BEFORE = -1;
    public static final int BRUSH_HIVE = 0;
    public static final int BRUSH_FOOD = 1;
    public static final int BRUSH_EMPTY = 2;
    public static final int BRUSH_BORDER = 3;
    private final int HIVE_SIZE = 2;
    private MapPoint[][] map;
    private ArrayList<Ant> ants;
    private int num_x_points = 1;
    private int num_y_points = 1;
    private int x_pixels;
    private int y_pixels;
    private boolean mouse_pressed = false;
    private int dead_food = 0;
    private int brush_size;
    private int brush_type;
    private boolean running = false;
    private int hive_location_x = -1;
    private int hive_location_y = -1;
    private boolean hive_exists = false;
    private MapPanel th = this;

    public MapPanel() {
        this.addMouseListener(this);
        this.setBackground(this.COLOR_BORDER);
    }

    public boolean hiveExists() {
        return this.hive_exists;
    }

    public Point getHiveLocation() {
        if (this.hive_location_x == -1 && this.hive_location_y == -1) {
            return null;
        }
        return new Point(this.hive_location_x, this.hive_location_y);
    }

    public void setBrush(int brush_size, int brush_type) {
        this.brush_size = brush_size;
        if (brush_type != -1) {
            this.brush_type = brush_type;
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getDeadFood() {
        return this.dead_food;
    }

    public void resetDeadFood() {
        this.dead_food = 0;
    }

    private void changeMapPointType(MapPoint mp) {
        if (this.running || mp == null || mp.isBorderPoint(this.num_x_points, this.num_y_points)) {
            return;
        }
        int plaque_size = this.brush_size;
        Point pos = mp.getPosition();
        int newType = 2;
        if (this.brush_type == 0) {
            this.mouse_pressed = false;
            int i = 0;
            while (i < this.num_x_points) {
                int j = 0;
                while (j < this.num_y_points) {
                    if (this.map[i][j].returnType() == 1) {
                        JOptionPane.showMessageDialog(this, "Only one nest is allowed!", "Information", 1);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            mp.setType(1);
            this.hive_exists = true;
            this.hive_location_x = mp.getPosition().x;
            this.hive_location_y = mp.getPosition().y;
        } else {
            if (this.brush_type == 1) {
                newType = 0;
            } else if (this.brush_type == 3) {
                newType = 3;
            }
            int dx = 0;
            while (dx < plaque_size) {
                int dy = 0;
                while (dy < plaque_size) {
                    if ((int)pos.getX() + dx < this.num_x_points - 1 && (int)pos.getY() + dy < this.num_y_points - 1) {
                        if (newType == 3) {
                            int i = 0;
                            while (i < this.ants.size()) {
                                Point antPos = this.ants.get(i).getPosition();
                                if (antPos.getX() == pos.getX() + (double)dx && antPos.getY() == pos.getY() + (double)dy) {
                                    this.dead_food += this.ants.get(i).getFood();
                                    this.ants.remove(i);
                                }
                                ++i;
                            }
                        }
                        if (this.map[(int)pos.getX() + dx][(int)pos.getY() + dy].returnType() == 1) {
                            this.hive_exists = false;
                        }
                        this.map[(int)pos.getX() + dx][(int)pos.getY() + dy].setType(newType);
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        this.repaint();
    }

    private MapPoint locateMapPoint(Point p) {
        if (p == null) {
            return null;
        }
        int i = (int)Math.floor(p.getX() / (double)this.x_pixels);
        int j = (int)Math.floor(p.getY() / (double)this.y_pixels);
        if (i < this.num_x_points && j < this.num_y_points) {
            return this.map[i][j];
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.x_pixels = (int)Math.floor(this.getWidth() / this.num_x_points);
        this.y_pixels = (int)Math.floor(this.getHeight() / this.num_y_points);
        this.drawMap(g);
    }

    public void setMap(MapPoint[][] map, ArrayList<Ant> ants, Point hive_pos) {
        this.map = map;
        this.ants = ants;
        this.num_x_points = map.length;
        this.num_y_points = map[0].length;
        this.hive_location_x = (int)hive_pos.getX();
        this.hive_location_y = (int)hive_pos.getY();
    }

    public void clearMap() {
        int i = 0;
        while (i < this.num_x_points) {
            int j = 0;
            while (j < this.num_y_points) {
                this.map[i][j] = this.map[i][j].isBorderPoint(this.num_x_points, this.num_y_points) ? new MapPoint(4, new Point(i, j)) : new MapPoint(2, new Point(i, j));
                ++j;
            }
            ++i;
        }
        this.hive_exists = false;
    }

    private void drawMap(Graphics gBuf) {
        if (this.map == null) {
            return;
        }
        int i = 0;
        while (i < this.num_x_points) {
            int j = 0;
            while (j < this.num_y_points) {
                if (this.map[i][j].returnType() == 2) {
                    double phConc = this.map[i][j].getPhConcentration();
                    if (phConc <= 0.0) {
                        gBuf.setColor(this.COLOR_EMPTY);
                    } else if (phConc > 50.0) {
                        if (phConc > 100.0) {
                            phConc = 100.0;
                        }
                        gBuf.setColor(new Color(255, (int)(255.0 - Math.floor(2.0 * (phConc - 50.0) * 255.0 / 100.0)), 0));
                    } else {
                        gBuf.setColor(new Color(255, 255, (int)(255.0 - Math.floor(2.0 * phConc * 255.0 / 100.0))));
                    }
                    gBuf.fillRect(i * this.x_pixels, j * this.y_pixels, this.x_pixels, this.y_pixels);
                } else if (this.map[i][j].returnType() == 3) {
                    gBuf.setColor(this.COLOR_BORDER);
                    gBuf.fillRect(i * this.x_pixels, j * this.y_pixels, this.x_pixels, this.y_pixels);
                } else if (this.map[i][j].returnType() == 4) {
                    gBuf.setColor(this.COLOR_BORDER);
                    gBuf.fillRect(i * this.x_pixels, j * this.y_pixels, this.x_pixels, this.y_pixels);
                } else if (this.map[i][j].returnType() == 0) {
                    gBuf.setColor(this.COLOR_FOOD);
                    gBuf.fillRect(i * this.x_pixels, j * this.y_pixels, this.x_pixels, this.y_pixels);
                }
                ++j;
            }
            ++i;
        }
        if (this.ants != null) {
            i = 0;
            while (i < this.ants.size()) {
                Ant ant = this.ants.get(i);
                if (ant.getState() == 1) {
                    gBuf.setColor(this.COLOR_ANTS_FOLLOWER);
                } else if (ant.getState() == 2) {
                    gBuf.setColor(this.COLOR_ANTS_RETURNER);
                } else if (ant.getState() == 3) {
                    gBuf.setColor(this.COLOR_ANTS_RETURNER2);
                } else {
                    gBuf.setColor(this.COLOR_ANTS);
                }
                Point p = ant.getPosition();
                gBuf.fillRect(p.x * this.x_pixels, p.y * this.y_pixels, this.x_pixels, this.y_pixels);
                ++i;
            }
        }
        i = 0;
        while (i < this.num_x_points) {
            int j = 0;
            while (j < this.num_y_points) {
                if (this.map[i][j].returnType() == 1) {
                    gBuf.setColor(this.COLOR_HIVE);
                    gBuf.fillRect(i * this.x_pixels, j * this.y_pixels, this.x_pixels, this.y_pixels);
                    this.hive_location_x = i;
                    this.hive_location_y = j;
                    this.hive_exists = true;
                    int m = -2;
                    while (m <= 2) {
                        int n = -2;
                        while (n <= 2) {
                            if (!(this.map[i + m][j + n].isBorderPoint(this.num_x_points, this.num_y_points) || m == 0 && n == 0)) {
                                this.map[i + m][j + n].setType(2);
                                gBuf.fillRect((i + m) * this.x_pixels, (j + n) * this.y_pixels, this.x_pixels, this.y_pixels);
                            }
                            ++n;
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouse_pressed = true;
        Thread paintThread = new Thread(){

            @Override
            public void run() {
                do {
                    MapPanel.this.changeMapPointType(MapPanel.this.locateMapPoint(MapPanel.this.th.getMousePosition(true)));
                } while (MapPanel.this.mouse_pressed);
            }
        };
        paintThread.start();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouse_pressed = false;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }
}

