/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.RandomMap;
import controller.TimerClass;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.Ant;
import model.MapPoint;
import view.MapPanel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final float BUTTON_WIDTH = 0.15f;
    private final float ABOUTBUTTON_WIDTH = 0.15f;
    private final float SPINNER_WIDTH = 0.04f;
    private final float BUTTON_HEIGHT = 0.06f;
    private final float ABOUTBUTTON_HEIGHT = 0.04f;
    private final float RADIO_HEIGHT = 0.04f;
    private final float SLIDER_HEIGHT = 0.03f;
    private final float LABEL_HEIGHT = 0.03f;
    private final float BORDER_SIZE = 0.033f;
    private final float BUTTON_DIST = 0.02f;
    private final Color COLOR_BACKGROUND = Color.gray;
    private final Font SLIDER_FONT = new Font("Arial", 0, 10);
    private final Font LABEL_FONT = new Font("Arial", 0, 11);
    private final Font RADIO_FONT = new Font("Arial", 0, 11);
    private final Font BUTTON_FONT = new Font("Arial", 0, 12);
    private final float MIN_WIDTH = 0.7f;
    private final float MIN_HEIGHT = 0.6f;
    private final int MAX_ANT_SPAWN = 99;
    private final int MIN_ANT_SPAWN = 1;
    private final int STD_ANT_SPAWN = 50;
    private final int MIN_PERIOD = 5;
    private final int MAX_PERIOD = 1000;
    private final int STD_PERIOD = 10;
    private final int MAX_BRUSHSIZE = 6;
    private final int MIN_BRUSHSIZE = 1;
    private final int STD_BRUSHSIZE = 3;
    private final double MAX_DECAY_CONSTANT = 0.01;
    private final double MIN_DECAY_CONSTANT = 0.0;
    public static final double STD_DECAY_CONSTANT = 0.006;
    private final double MAX_PH_DROP = 20.0;
    private final double MIN_PH_DROP = 0.0;
    public static final double STD_PH_DROP = 5.0;
    private JPanel mainPanel;
    private MapPanel mapPanel = null;
    private JButton startButton;
    private JButton spawnButton;
    private JButton randomButton;
    private JButton clearMapButton;
    private JButton clearAntsButton;
    private JRadioButton foodRadio;
    private JRadioButton hiveRadio;
    private JRadioButton emptyRadio;
    private JRadioButton borderRadio;
    private ButtonGroup bGroup;
    private JSlider speedSlider;
    private JLabel speedLabel;
    private JSlider brushSlider;
    private JLabel brushLabel;
    private JSlider decaySlider;
    private JLabel decayLabel;
    private JSlider dropSlider;
    private JLabel dropLabel;
    private JLabel antcountLabel;
    private JLabel foodLabel;
    private JLabel foodrateLabel;
    private JCheckBox finiteFood;
    private JSpinner antSpinner;
    private JButton aboutButton;
    private ArrayList<Ant> ants = null;
    private MapPoint[][] map = null;
    private Timer timer;
    private TimerClass action;
    private boolean running;
    private int old_food;
    private int foodrate_c;
    public static final int NUM_X_POINTS = 150;
    public static final int NUM_Y_POINTS = 100;
    public static final int FOOD_AMOUNT = 10;
    public static final int FOOD_SIZE = 6;
    public static final int START_AMOUNT_ANTS = 50;

    public static void main(String[] args) {
        MainFrame mFrame = new MainFrame();
        mFrame.init();
    }

    public MainFrame() {
        super("Ants Simulation 1.0");
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    public void init() {
        this.running = false;
        this.old_food = 0;
        this.foodrate_c = 100;
        this.initComponents();
        this.map = new MapPoint[150][100];
        this.ants = new ArrayList();
        Point hive_pos = RandomMap.getMap(this.map, this.ants);
        this.mapPanel.setMap(this.map, this.ants, hive_pos);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainFrame.this.sizeComponents();
            }
        });
        final MainFrame th = this;
        this.speedSlider.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int freq = MainFrame.this.speedSlider.getValue();
                MainFrame.this.speedSlider.setToolTipText(String.valueOf(Integer.toString(freq)) + " Hz");
                if (MainFrame.this.running) {
                    MainFrame.this.timer.cancel();
                    MainFrame.this.timer = new Timer();
                    MainFrame.this.action = new TimerClass(MainFrame.this.ants, MainFrame.this.map, th, freq);
                    MainFrame.this.timer.schedule((TimerTask)MainFrame.this.action, 0L, (long)(1000 / freq));
                }
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.setFocusable(true);
    }

    public void start() {
    }

    public void stop() {
    }

    private void initComponents() {
        int full_width = Math.round(0.7f * (float)Toolkit.getDefaultToolkit().getScreenSize().width);
        int full_height = Math.round(0.6f * (float)Toolkit.getDefaultToolkit().getScreenSize().height);
        this.setBounds(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - full_width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - full_height / 2, full_width, full_height);
        this.setMinimumSize(new Dimension(full_width, full_height));
        this.mainPanel = new JPanel();
        this.mapPanel = new MapPanel();
        this.mapPanel.setBrush(3, 1);
        this.mainPanel.add(this.mapPanel);
        this.startButton = new JButton("Start");
        this.startButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.startButtonActionPerformed(evt);
            }
        });
        this.spawnButton = new JButton("Spawn Ants");
        this.spawnButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.spawnButton);
        this.spawnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.spawnButtonActionPerformed(evt);
            }
        });
        this.antSpinner = new JSpinner(new SpinnerNumberModel(50, 1, 99, 1));
        this.antSpinner.setBackground(this.COLOR_BACKGROUND);
        this.antSpinner.setBorder(null);
        ((JSpinner.DefaultEditor)this.antSpinner.getEditor()).getTextField().setEditable(false);
        this.mainPanel.add(this.antSpinner);
        this.antcountLabel = new JLabel();
        this.antcountLabel.setBackground(this.COLOR_BACKGROUND);
        this.antcountLabel.setFont(this.LABEL_FONT);
        this.mainPanel.add(this.antcountLabel);
        this.foodLabel = new JLabel();
        this.foodLabel.setBackground(this.COLOR_BACKGROUND);
        this.foodLabel.setFont(this.LABEL_FONT);
        this.mainPanel.add(this.foodLabel);
        this.foodrateLabel = new JLabel();
        this.foodrateLabel.setBackground(this.COLOR_BACKGROUND);
        this.foodrateLabel.setFont(this.LABEL_FONT);
        this.mainPanel.add(this.foodrateLabel);
        this.finiteFood = new JCheckBox("Finite food amount");
        this.finiteFood.setBackground(this.COLOR_BACKGROUND);
        this.finiteFood.setSelected(MapPoint.getFinite());
        this.finiteFood.setFont(this.LABEL_FONT);
        this.mainPanel.add(this.finiteFood);
        this.finiteFood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.finiteFoodActionPerformed(evt);
            }
        });
        this.randomButton = new JButton("Random map");
        this.randomButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.randomButton);
        this.randomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.randomButtonActionPerformed(evt);
            }
        });
        this.clearMapButton = new JButton("Clear map");
        this.clearMapButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.clearMapButton);
        this.clearMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.clearMapButtonActionPerformed(evt);
            }
        });
        this.clearAntsButton = new JButton("Clear ants");
        this.clearAntsButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.clearAntsButton);
        this.clearAntsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.clearAntsButtonActionPerformed(evt);
            }
        });
        this.speedLabel = new JLabel("Speed:");
        this.speedLabel.setBackground(this.COLOR_BACKGROUND);
        this.speedLabel.setFont(this.SLIDER_FONT);
        this.mainPanel.add(this.speedLabel);
        this.speedSlider = new JSlider();
        this.speedSlider.setBackground(this.COLOR_BACKGROUND);
        this.speedSlider.setMaximum(200);
        this.speedSlider.setMinimum(1);
        this.speedSlider.setValue(100);
        this.mainPanel.add(this.speedSlider);
        this.brushLabel = new JLabel("Brush size:");
        this.brushLabel.setBackground(this.COLOR_BACKGROUND);
        this.brushLabel.setFont(this.SLIDER_FONT);
        this.mainPanel.add(this.brushLabel);
        this.brushSlider = new JSlider();
        this.brushSlider.setBackground(this.COLOR_BACKGROUND);
        this.brushSlider.setMaximum(6);
        this.brushSlider.setMinimum(1);
        this.brushSlider.setValue(3);
        this.brushSlider.setMajorTickSpacing(1);
        this.brushSlider.setPaintTicks(true);
        this.mainPanel.add(this.brushSlider);
        this.brushSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.brushSliderStateChanged(e);
            }
        });
        this.decayLabel = new JLabel("Pheromone decay constant:");
        this.decayLabel.setBackground(this.COLOR_BACKGROUND);
        this.decayLabel.setFont(this.SLIDER_FONT);
        this.mainPanel.add(this.decayLabel);
        this.decaySlider = new JSlider();
        this.decaySlider.setBackground(this.COLOR_BACKGROUND);
        this.decaySlider.setMaximum(10);
        this.decaySlider.setMinimum(0);
        this.decaySlider.setValue(6);
        this.decaySlider.setMajorTickSpacing(1);
        this.decaySlider.setPaintTicks(true);
        this.mainPanel.add(this.decaySlider);
        this.decaySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.decaySliderStateChanged(e);
            }
        });
        this.dropLabel = new JLabel("Pheromone drop:");
        this.dropLabel.setBackground(this.COLOR_BACKGROUND);
        this.dropLabel.setFont(this.SLIDER_FONT);
        this.mainPanel.add(this.dropLabel);
        this.dropSlider = new JSlider();
        this.dropSlider.setBackground(this.COLOR_BACKGROUND);
        this.dropSlider.setMaximum(20);
        this.dropSlider.setMinimum(0);
        this.dropSlider.setValue(5);
        this.dropSlider.setMajorTickSpacing(1);
        this.dropSlider.setPaintTicks(true);
        this.mainPanel.add(this.dropSlider);
        this.dropSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.dropSliderStateChanged(e);
            }
        });
        this.foodRadio = new JRadioButton("Food");
        this.foodRadio.setBackground(this.COLOR_BACKGROUND);
        this.foodRadio.setFont(this.RADIO_FONT);
        this.mainPanel.add(this.foodRadio);
        this.foodRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.foodRadioActionPerformed(evt);
            }
        });
        this.hiveRadio = new JRadioButton("Nest");
        this.hiveRadio.setBackground(this.COLOR_BACKGROUND);
        this.hiveRadio.setFont(this.RADIO_FONT);
        this.mainPanel.add(this.hiveRadio);
        this.hiveRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.hiveRadioActionPerformed(evt);
            }
        });
        this.borderRadio = new JRadioButton("Obstacle");
        this.borderRadio.setBackground(this.COLOR_BACKGROUND);
        this.borderRadio.setFont(this.RADIO_FONT);
        this.mainPanel.add(this.borderRadio);
        this.borderRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.borderRadioActionPerformed(evt);
            }
        });
        this.emptyRadio = new JRadioButton("Empty");
        this.emptyRadio.setBackground(this.COLOR_BACKGROUND);
        this.emptyRadio.setFont(this.RADIO_FONT);
        this.mainPanel.add(this.emptyRadio);
        this.emptyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.emptyRadioActionPerformed(evt);
            }
        });
        this.bGroup = new ButtonGroup();
        this.bGroup.add(this.foodRadio);
        this.bGroup.add(this.hiveRadio);
        this.bGroup.add(this.borderRadio);
        this.bGroup.add(this.emptyRadio);
        this.foodRadio.setSelected(true);
        this.aboutButton = new JButton("About");
        this.aboutButton.setFont(this.BUTTON_FONT);
        this.mainPanel.add(this.aboutButton);
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutButtonActionPerformed(evt);
            }
        });
        this.setContentPane(this.mainPanel);
        this.setVisible(true);
        this.sizeComponents();
        this.repaint();
    }

    private void sizeComponents() {
        Dimension full = this.mainPanel.getSize();
        int border_size = Math.round((float)full.height * 0.033f);
        int button_dist = Math.round((float)full.height * 0.02f);
        int button_width = Math.round((float)full.width * 0.15f);
        int spinner_width = Math.round((float)full.width * 0.04f);
        int button_height = Math.round((float)full.height * 0.06f);
        int radio_height = Math.round((float)full.height * 0.04f);
        int slider_height = Math.round((float)full.height * 0.03f);
        int label_height = Math.round((float)full.height * 0.03f);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(this.COLOR_BACKGROUND);
        this.mapPanel.setLayout(null);
        this.mapPanel.setBounds(0, 0, full.width - button_width - 2 * border_size, full.height);
        this.startButton.setBounds(full.width - border_size - button_width, border_size, button_width, button_height);
        this.spawnButton.setBounds(full.width - border_size - button_width, border_size + button_height + button_dist, button_width - spinner_width, button_height);
        this.antSpinner.setBounds(full.width - border_size - spinner_width, border_size + button_height + button_dist + Math.round(0.5f * (float)(button_height - label_height)), spinner_width, label_height);
        this.antcountLabel.setText("");
        this.antcountLabel.setBounds(full.width - border_size - button_width, border_size + 2 * button_height + 2 * button_dist, button_width, label_height);
        this.foodLabel.setBounds(full.width - border_size - button_width, border_size + 2 * button_height + 2 * button_dist + label_height, button_width, label_height);
        this.foodrateLabel.setBounds(full.width - border_size - button_width, border_size + 2 * button_height + 2 * button_dist + 2 * label_height, button_width, label_height);
        this.finiteFood.setBounds(full.width - border_size - button_width, border_size + 2 * button_height + 2 * button_dist + 2 * label_height + radio_height, button_width, radio_height);
        this.randomButton.setBounds(full.width - border_size - button_width, border_size + 2 * button_height + 3 * button_dist + 3 * label_height + radio_height, button_width, button_height);
        this.clearMapButton.setBounds(full.width - border_size - button_width, border_size + 3 * button_height + 4 * button_dist + 3 * label_height + radio_height, button_width, button_height);
        this.clearAntsButton.setBounds(full.width - border_size - button_width, border_size + 4 * button_height + 5 * button_dist + 3 * label_height + radio_height, button_width, button_height);
        this.speedLabel.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 6 * button_dist + 3 * label_height + radio_height, button_width, label_height);
        this.speedSlider.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 4 * label_height + 6 * button_dist + radio_height, button_width, slider_height);
        this.brushLabel.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + slider_height + 4 * label_height + 6 * button_dist + radio_height, button_width, label_height);
        this.brushSlider.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + slider_height + 5 * label_height + 6 * button_dist + radio_height, button_width, slider_height);
        this.decayLabel.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 2 * slider_height + 5 * label_height + 6 * button_dist + radio_height, button_width, label_height);
        this.decaySlider.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 2 * slider_height + 6 * label_height + 6 * button_dist + radio_height, button_width, slider_height);
        this.dropLabel.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 3 * slider_height + 6 * label_height + 6 * button_dist + radio_height, button_width, label_height);
        this.dropSlider.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 3 * slider_height + 7 * label_height + 6 * button_dist + radio_height, button_width, slider_height);
        this.foodRadio.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 4 * slider_height + 7 * label_height + 7 * button_dist + radio_height, Math.round(button_width / 2), radio_height);
        this.hiveRadio.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 4 * slider_height + 7 * label_height + 7 * button_dist + 2 * radio_height, Math.round(button_width / 2), radio_height);
        this.borderRadio.setBounds(full.width - border_size - Math.round(button_width / 2), border_size + 5 * button_height + 4 * slider_height + 7 * label_height + 7 * button_dist + radio_height, Math.round(button_width / 2), radio_height);
        this.emptyRadio.setBounds(full.width - border_size - Math.round(button_width / 2), border_size + 5 * button_height + 4 * slider_height + 7 * label_height + 7 * button_dist + 2 * radio_height, Math.round(button_width / 2), radio_height);
        this.aboutButton.setBounds(full.width - border_size - button_width, border_size + 5 * button_height + 4 * slider_height + 7 * label_height + 8 * button_dist + 3 * radio_height, Math.round((float)full.width * 0.15f), Math.round((float)full.height * 0.04f));
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        if (!this.mapPanel.hiveExists()) {
            JOptionPane.showMessageDialog(this, "There has to be a nest somewhere!", "Information", 1);
        } else if (!this.running) {
            this.timer = new Timer();
            this.action = new TimerClass(this.ants, this.map, this, this.speedSlider.getValue());
            this.timer.schedule((TimerTask)this.action, 0L, (long)(1000 / this.speedSlider.getValue()));
            this.startButton.setText("Stop");
            this.randomButton.setEnabled(false);
            this.clearMapButton.setEnabled(false);
            this.clearAntsButton.setEnabled(false);
            this.foodRadio.setEnabled(false);
            this.hiveRadio.setEnabled(false);
            this.borderRadio.setEnabled(false);
            this.emptyRadio.setEnabled(false);
            this.running = true;
            this.mapPanel.setRunning(true);
        } else {
            this.timer.cancel();
            this.startButton.setText("Start");
            this.randomButton.setEnabled(true);
            this.clearMapButton.setEnabled(true);
            this.clearAntsButton.setEnabled(true);
            this.foodRadio.setEnabled(true);
            this.hiveRadio.setEnabled(true);
            this.borderRadio.setEnabled(true);
            this.emptyRadio.setEnabled(true);
            this.running = false;
            this.mapPanel.setRunning(false);
            this.repaint();
        }
    }

    private void spawnButtonActionPerformed(ActionEvent evt) {
        if (this.mapPanel.hiveExists() && this.mapPanel.getHiveLocation() != null) {
            Integer amount = (Integer)this.antSpinner.getValue();
            int i = 0;
            while (i < amount) {
                this.ants.add(new Ant(this.mapPanel.getHiveLocation(), this.map));
                ++i;
            }
            this.repaint();
        }
    }

    private void finiteFoodActionPerformed(ActionEvent evt) {
        MapPoint.setFinite(this.finiteFood.isSelected());
    }

    private void randomButtonActionPerformed(ActionEvent evt) {
        this.clearMapButtonActionPerformed(null);
        Point hive_pos = RandomMap.getMap(this.map, this.ants);
        this.mapPanel.setMap(this.map, this.ants, hive_pos);
    }

    private void clearMapButtonActionPerformed(ActionEvent evt) {
        this.mapPanel.clearMap();
        this.clearAntsButtonActionPerformed(null);
    }

    private void clearAntsButtonActionPerformed(ActionEvent evt) {
        this.ants.clear();
        this.mapPanel.resetDeadFood();
        this.repaint();
    }

    private void brushSliderStateChanged(ChangeEvent e) {
        this.brushSlider.setToolTipText(Integer.toString(this.brushSlider.getValue()));
        this.mapPanel.setBrush(this.brushSlider.getValue(), -1);
    }

    private void decaySliderStateChanged(ChangeEvent e) {
        double dc = (double)this.decaySlider.getValue() / 1000.0;
        this.decaySlider.setToolTipText(Double.toString(dc));
        int i = 0;
        while (i < 150) {
            int j = 0;
            while (j < 100) {
                this.map[i][j].setDecayConstant(dc);
                ++j;
            }
            ++i;
        }
    }

    private void dropSliderStateChanged(ChangeEvent e) {
        this.dropSlider.setToolTipText(Integer.toString(this.dropSlider.getValue()));
        int i = 0;
        while (i < this.ants.size()) {
            this.ants.get(i).setPhDrop(this.dropSlider.getValue());
            ++i;
        }
    }

    private void foodRadioActionPerformed(ActionEvent evt) {
        this.mapPanel.setBrush(this.brushSlider.getValue(), 1);
    }

    private void hiveRadioActionPerformed(ActionEvent evt) {
        this.mapPanel.setBrush(this.brushSlider.getValue(), 0);
    }

    private void borderRadioActionPerformed(ActionEvent evt) {
        this.mapPanel.setBrush(this.brushSlider.getValue(), 3);
    }

    private void emptyRadioActionPerformed(ActionEvent evt) {
        this.mapPanel.setBrush(this.brushSlider.getValue(), 2);
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Ants Simulation Version 1.0 (17th July 2014)\n\nby Peter Kuhn, Jannik Luboeinski, Laura Martin, Marius Schneider", "About Ants Simulation", 1);
    }

    public void incFoodRateCounter() {
        ++this.foodrate_c;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.ants != null) {
            int food = 0;
            this.antcountLabel.setText("Total ants: " + Integer.toString(this.ants.size()));
            int i = 0;
            while (i < this.ants.size()) {
                food += this.ants.get(i).getFood();
                ++i;
            }
            this.foodLabel.setText("Collected food: " + Integer.toString(food += this.mapPanel.getDeadFood()));
            if (this.foodrate_c >= this.speedSlider.getValue()) {
                this.foodrateLabel.setText("Collecting rate: " + Integer.toString(food - this.old_food) + "/s");
                this.old_food = food;
                this.foodrate_c = 0;
            }
        } else {
            this.antcountLabel.setText("Total ants: 0");
            this.foodLabel.setText("Collected food: 0");
            this.foodrateLabel.setText("Collecting rate: 0/s");
        }
    }
}

