/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.Point;

public class MapPoint {
    public static final int TYPE_FOOD = 0;
    public static final int TYPE_HIVE = 1;
    public static final int TYPE_EMPTY = 2;
    public static final int TYPE_BORDER = 3;
    public static final int TYPE_BORDER2 = 4;
    public static final double MAX_CONCENTRATION = 100.0;
    public static final int MAX_FOOD_CONCENTRATION = 30;
    private static boolean finite_food = false;
    private double decay_constant = 0.006;
    private int type;
    private double phConcentration;
    private Point position;
    private int foodConcentration;
    private boolean beingCollected;

    public MapPoint(int type, Point position) {
        this.type = type;
        this.phConcentration = 0.0;
        this.position = position;
        this.foodConcentration = 0;
        this.beingCollected = false;
    }

    public void setBeingCollected(boolean be) {
        this.beingCollected = be;
    }

    public boolean beingCollected() {
        return this.beingCollected;
    }

    public static void setFinite(boolean finite) {
        finite_food = finite;
    }

    public static boolean getFinite() {
        return finite_food;
    }

    public void setDecayConstant(double decay_constant) {
        this.decay_constant = decay_constant;
    }

    public void phDecay() {
        this.phConcentration = (1.0 - this.decay_constant) * this.phConcentration;
    }

    public void phIncrease(double delta_ph) {
        if (this.type != 3 || this.type != 4) {
            this.phConcentration += delta_ph;
        }
    }

    public void setType(int type) {
        this.type = type;
        if (type == 3 || type == 4) {
            this.phConcentration = 0.0;
            this.foodConcentration = 0;
        } else if (type == 0) {
            this.setFoodConcentration(30);
        }
    }

    public int returnType() {
        return this.type;
    }

    public double getPhConcentration() {
        return this.phConcentration;
    }

    public int getFoodConcentration() {
        return this.foodConcentration;
    }

    public void setFoodConcentration(int foodConcentration) {
        this.foodConcentration = foodConcentration;
    }

    public void FoodDecrease() {
        if (finite_food) {
            --this.foodConcentration;
            if (this.foodConcentration == 0) {
                this.setType(2);
            }
        }
    }

    public Point getPosition() {
        return this.position;
    }

    public boolean isBorderPoint(int num_x_points, int num_y_points) {
        return this.position.x == 0 || this.position.y == 0 || this.position.x == num_x_points - 1 || this.position.y == num_y_points - 1;
    }
}

