/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import model.MapPoint;

public class Ant {
    public static final int ANT_SEEKER = 0;
    public static final int ANT_FOLLOWER = 1;
    public static final int ANT_RETURNER = 2;
    public static final int ANT_RETURNER2 = 3;
    private final double SEEKER_ANGLE = 70.0;
    private final double FOLLOWER_ANGLE = 360.0;
    private int state;
    private ArrayList<Point> way;
    private Point position;
    private int max_waysize;
    private Point direction;
    private int max_way;
    private final int SEEKER_PROB = (int)Math.round(105.0);
    private final int ASSESS_FOOD_RADIUS = 1;
    private final int PH_FOOD_MULTIPLIER = 5;
    private final int PH_FOOD_MULTIPLIER_LENGTH = 10;
    private final int SIDE_DROP = 2;
    private double ph_increase;
    private double follower_to_seeker;
    private double hive_radius;
    private int food;
    private MapPoint[] area = new MapPoint[8];
    private static Random randomGenerator = new Random();

    public Ant(Point spawnPoint, MapPoint[][] Map) {
        this.max_waysize = 5 * Map.length * Map[0].length / 100;
        this.hive_radius = 25.0;
        this.setPhDrop(5.0);
        this.position = spawnPoint.getLocation();
        this.way = new ArrayList();
        this.way.add(spawnPoint.getLocation());
        this.direction = new Point(0, 0);
        this.food = 0;
        this.max_way = 0;
        this.change_state(Map, (int)this.position.getX(), (int)this.position.getY());
    }

    public void setPhDrop(double ph_increase) {
        this.ph_increase = ph_increase;
        this.follower_to_seeker = ph_increase / 10.0;
    }

    private double DistFunction(int X, int Y) {
        double hive_dist = this.HiveDistance(X, Y);
        return 1.0;
    }

    private double BorderCount(int PosX, int PosY, MapPoint[][] Map) {
        int bordercount = 0;
        int xdelta = -1;
        while (xdelta < 2) {
            int ydelta = -1;
            while (ydelta < 2) {
                if ((xdelta != 0 || ydelta != 0) && Map[PosX + xdelta][PosY + ydelta].returnType() == 4) {
                    ++bordercount;
                }
                ++ydelta;
            }
            ++xdelta;
        }
        return bordercount;
    }

    private int RandomFollow() {
        int result = randomGenerator.nextInt(101);
        return result;
    }

    private int RandomMove() {
        int result = randomGenerator.nextInt(3) - 1;
        return result;
    }

    private int SeekOrFollow() {
        int result = randomGenerator.nextInt(this.SEEKER_PROB);
        return result;
    }

    private void phIncrease3Felder(MapPoint[][] MP, int PosX, int PosY, int dirX, int dirY) {
        double phinc_side;
        double phinc;
        if (this.max_way - this.way.size() < 10) {
            phinc = this.ph_increase * 5.0;
            phinc_side = this.ph_increase * 5.0 / 2.0;
        } else {
            phinc = this.ph_increase;
            phinc_side = this.ph_increase / 2.0;
        }
        MP[PosX][PosY].phIncrease(phinc);
        if (Math.abs(dirX) <= 1 && Math.abs(dirY) <= 1) {
            int idx = -1;
            while (idx <= 1) {
                int idy = -1;
                while (idy <= 1) {
                    if (idx != 0 || idy != 0) {
                        MP[PosX + idx][PosY + idy].phIncrease(phinc_side);
                    }
                    ++idy;
                }
                ++idx;
            }
        }
    }

    private double HiveDistance(int PosX, int PosY) {
        Point spawnPoint = null;
        if (this.way.size() >= 1) {
            spawnPoint = this.way.get(this.way.size() - 1);
        }
        if (spawnPoint != null) {
            return Math.sqrt(Math.abs(Math.pow((double)PosX - spawnPoint.getX(), 2.0)) + Math.abs(Math.pow((double)PosY - spawnPoint.getY(), 2.0)));
        }
        return 0.0;
    }

    public int getFood() {
        return this.food;
    }

    private Point nearbyFood(MapPoint[][] MP, int PosX, int PosY) {
        int dx = -1;
        while (dx <= 1) {
            int dy = -1;
            while (dy <= 1) {
                if (PosX + dx >= 0 && PosY + dy >= 0 && PosX + dx < MP.length && PosY + dy < MP[0].length && MP[PosX + dx][PosY + dy].returnType() == 0) {
                    return new Point(dx, dy);
                }
                ++dy;
            }
            ++dx;
        }
        return null;
    }

    private void change_state(MapPoint[][] MP, int PosX, int PosY) {
        int type = MP[PosX][PosY].returnType();
        if (this.way.size() > this.max_waysize && this.state == 0) {
            this.state = 3;
        } else if (type == 1) {
            int Random2 = this.SeekOrFollow();
            int dx = -1;
            while (dx < 2) {
                int dy = -1;
                while (dy < 2) {
                    if ((dx != 0 || dy != 0) && (int)Math.round(MP[PosX + dx][PosY + dy].getPhConcentration()) > Random2) {
                        this.state = 1;
                        return;
                    }
                    ++dy;
                }
                ++dx;
            }
            if (this.state != 1) {
                this.state = 0;
            }
        } else if (type == 0) {
            if (this.state != 2 && !MP[PosX][PosY].beingCollected()) {
                ++this.food;
                MP[PosX][PosY].setBeingCollected(true);
                MP[PosX][PosY].FoodDecrease();
            }
            this.state = 2;
            this.max_way = this.way.size();
        }
    }

    private double RichtungsWinkelInDegree(int dx, int dy) {
        double SkalarProd = this.direction.getX() * (double)dx + this.direction.getY() * (double)dy;
        if (SkalarProd == 0.0) {
            return 90.0;
        }
        double betrag_dr = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        double betrag_adr = Math.sqrt(Math.pow(this.direction.getX(), 2.0) + Math.pow(this.direction.getY(), 2.0));
        double cosTheta = SkalarProd / (betrag_adr * betrag_dr);
        return Math.acos(cosTheta) * 180.0 / Math.PI;
    }

    private double RichtungsWinkel2(int dx, int dy) {
        double SkalarProd = this.direction.getX() * (double)dx + this.direction.getY() * (double)dy;
        if (SkalarProd == 0.0) {
            return 90.0;
        }
        double betrag_dr = Math.sqrt(Math.pow(this.direction.getX(), 2.0) + Math.pow(this.direction.getY(), 2.0));
        double betrag_adr = Math.sqrt(Math.pow(this.direction.getX(), 2.0) + Math.pow(this.direction.getY(), 2.0));
        double cosTheta = SkalarProd / (betrag_adr * betrag_dr);
        return Math.acos(cosTheta) * 180.0 / Math.PI;
    }

    public void move(MapPoint[][] Map) {
        int PosX = (int)this.position.getX();
        int PosY = (int)this.position.getY();
        if (this.state == 0) {
            int dy;
            int dx;
            Point nFood = this.nearbyFood(Map, PosX, PosY);
            if (nFood != null) {
                dx = (int)nFood.getX();
                dy = (int)nFood.getY();
                PosX += dx;
                PosY += dy;
            } else if (this.way.size() > 1) {
                int n = 0;
                int xdelta = -1;
                while (xdelta < 2) {
                    int ydelta = -1;
                    while (ydelta < 2) {
                        if ((xdelta != 0 || ydelta != 0) && this.RichtungsWinkelInDegree(xdelta, ydelta) <= 70.0 && Map[PosX + xdelta][PosY + ydelta].returnType() != 3 && Map[PosX + xdelta][PosY + ydelta].returnType() != 4 && Map[PosX + xdelta][PosY + ydelta].returnType() != 1) {
                            this.area[n] = Map[PosX + xdelta][PosY + ydelta];
                            ++n;
                        }
                        ++ydelta;
                    }
                    ++xdelta;
                }
                if (n == 0) {
                    do {
                        dx = this.RandomMove();
                        dy = this.RandomMove();
                    } while (Map[PosX = (int)this.position.getX() + dx][PosY = (int)this.position.getY() + dy].returnType() == 3 || Map[PosX][PosY].returnType() == 4);
                } else {
                    int result = randomGenerator.nextInt(n);
                    PosX = (int)this.area[result].getPosition().getX();
                    PosY = (int)this.area[result].getPosition().getY();
                    dx = PosX - (int)this.way.get(0).getX();
                    dy = PosY - (int)this.way.get(0).getY();
                }
            } else {
                do {
                    dx = this.RandomMove();
                    dy = this.RandomMove();
                    PosX = (int)this.position.getX() + dx;
                    PosY = (int)this.position.getY() + dy;
                } while (dx == 0 && dy == 0 || Map[PosX][PosY].returnType() == 3 || Map[PosX][PosY].returnType() == 4);
            }
            this.direction.setLocation(dx, dy);
            this.way.add(0, new Point(PosX, PosY));
        } else if (this.state == 1) {
            if (this.BorderCount(PosX, PosY, Map) > 2.0) {
                this.state = 3;
            }
            double[] intervall = new double[8];
            double phSumm = 0.0;
            double norm = 0.0;
            int n = 0;
            int Random2 = this.RandomFollow();
            Point nFood = this.nearbyFood(Map, PosX, PosY);
            if (nFood != null) {
                PosX += (int)nFood.getX();
                PosY += (int)nFood.getY();
            } else {
                int dx = -1;
                while (dx < 2) {
                    int dy = -1;
                    while (dy < 2) {
                        if (!(dx == 0 & dy == 0) && this.HiveDistance(PosX, PosY) <= this.HiveDistance(PosX + dx, PosY + dy) && !this.way.contains(new Point(PosX + dx, PosY + dy)) && this.RichtungsWinkelInDegree(dx, dy) <= 360.0 && Map[PosX + dx][PosY + dy].returnType() != 4 && Map[PosX + dx][PosY + dy].returnType() != 3 && Map[PosX + dx][PosY + dy].getPhConcentration() > 0.0 && (Map[PosX][PosY].returnType() == 1 || (double)(PosX + dx) != this.way.get(1).getX() || (double)(PosY + dy) != this.way.get(1).getY())) {
                            this.area[n] = Map[PosX + dx][PosY + dy];
                            phSumm += this.phWeigh(this.area[n].getPhConcentration());
                            norm += this.phWeigh(this.area[n].getPhConcentration()) * this.DistFunction((int)this.area[n].getPosition().getX(), (int)this.area[n].getPosition().getY());
                            ++n;
                        }
                        ++dy;
                    }
                    ++dx;
                }
                if (phSumm < this.follower_to_seeker || n == 0) {
                    this.state = 0;
                } else {
                    intervall[0] = this.phWeigh(this.area[0].getPhConcentration()) * 100.0 / norm * this.DistFunction((int)this.area[0].getPosition().getX(), (int)this.area[0].getPosition().getY());
                    int i = 1;
                    while (i <= n - 1) {
                        intervall[i] = intervall[i - 1] + this.phWeigh(this.area[i].getPhConcentration()) * 100.0 / norm * this.DistFunction((int)this.area[i].getPosition().getX(), (int)this.area[i].getPosition().getY());
                        ++i;
                    }
                    i = 0;
                    while (i <= n - 1) {
                        if ((double)Random2 <= intervall[i]) {
                            PosX = (int)this.area[i].getPosition().getX();
                            PosY = (int)this.area[i].getPosition().getY();
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.way.add(0, new Point(PosX, PosY));
            if (this.way.size() > 1) {
                this.direction.setLocation(PosX - (int)this.way.get(1).getX(), PosY - (int)this.way.get(1).getY());
            } else if (this.way.size() == 1) {
                this.direction.setLocation(0, 0);
            }
        } else if (this.state == 2) {
            if (this.way.size() >= 1) {
                this.direction.setLocation((int)this.way.get(0).getX() - PosX, (int)this.way.get(0).getY() - PosY);
                PosX = (int)this.way.get(0).getX();
                PosY = (int)this.way.get(0).getY();
                if (this.way.size() > 1) {
                    this.way.remove(0);
                }
                this.phIncrease3Felder(Map, PosX, PosY, (int)this.direction.getX(), (int)this.direction.getY());
            }
        } else if (this.state == 3 && this.way.size() >= 1) {
            this.direction.setLocation((int)this.way.get(0).getX() - PosX, (int)this.way.get(0).getY() - PosY);
            PosX = (int)this.way.get(0).getX();
            PosY = (int)this.way.get(0).getY();
            if (this.way.size() > 1) {
                this.way.remove(0);
            }
        }
        this.position.setLocation(PosX, PosY);
        this.change_state(Map, PosX, PosY);
    }

    public int getState() {
        return this.state;
    }

    public Point getPosition() {
        return this.position.getLocation();
    }

    private double phWeigh(double ph) {
        return Math.pow(ph, 2.0);
    }
}

